
;CodeVisionAVR C Compiler V2.05.0 Professional
;(C) Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega32
;Program type             : Application
;Clock frequency          : 16,000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 512 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega32
	#pragma AVRPART MEMORY PROG_FLASH 32768
	#pragma AVRPART MEMORY EEPROM 1024
	#pragma AVRPART MEMORY INT_SRAM SIZE 2143
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	#define CALL_SUPPORTED 1

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0060
	.EQU __SRAM_END=0x085F
	.EQU __DSTACK_SIZE=0x0200
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _ds18b20_devices=R5
	.DEF _temper_int=R6
	.DEF _temp_out=R8
	.DEF _t=R10
	.DEF _hour=R4
	.DEF _h=R13
	.DEF _minut=R12

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer0_ovf_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00

_conv_delay_G100:
	.DB  0x64,0x0,0xC8,0x0,0x90,0x1,0x20,0x3
_bit_mask_G100:
	.DB  0xF8,0xFF,0xFC,0xFF,0xFE,0xFF,0xFF,0xFF
_tbl10_G103:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G103:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

_0x3:
	.DB  0x64
_0x0:
	.DB  0x25,0x69,0x3E,0x25,0x69,0x3E,0x25,0x69
	.DB  0x0,0x25,0x69,0x3A,0x25,0x69,0x3A,0x25
	.DB  0x69,0x0,0x54,0x3D,0x25,0x64,0xDF,0x43
	.DB  0x0,0x53,0x45,0x54,0x0,0x54,0x45,0x52
	.DB  0x4D,0x49,0x4E,0x41,0x4C,0x0,0x53,0x45
	.DB  0x54,0x20,0x48,0x4F,0x55,0x52,0x0,0x53
	.DB  0x45,0x54,0x20,0x4D,0x49,0x4E,0x55,0x54
	.DB  0x0,0x53,0x45,0x54,0x20,0x53,0x45,0x4B
	.DB  0x55,0x4E,0x44,0x0,0x53,0x45,0x54,0x20
	.DB  0x44,0x41,0x59,0x0,0x53,0x45,0x54,0x20
	.DB  0x4D,0x4F,0x4E,0x54,0x48,0x0,0x53,0x45
	.DB  0x54,0x20,0x59,0x45,0x41,0x52,0x0,0x4C
	.DB  0x45,0x44,0x20,0x44,0x49,0x53,0x50,0x4C
	.DB  0x41,0x59,0x0,0x54,0x69,0x6D,0x65,0x3A
	.DB  0x20,0x25,0x69,0x0,0x50,0x72,0x65,0x73
	.DB  0x73,0x20,0x6F,0x6B,0x20,0x66,0x6F,0x72
	.DB  0x20,0x20,0x20,0x20,0x63,0x68,0x65,0x63
	.DB  0x6B,0x20,0x64,0x69,0x73,0x70,0x6C,0x61
	.DB  0x79,0x0,0x44,0x69,0x73,0x70,0x6C,0x61
	.DB  0x79,0x20,0x63,0x68,0x65,0x63,0x6B,0x20
	.DB  0x20,0x20,0x69,0x73,0x20,0x73,0x74,0x61
	.DB  0x72,0x74,0x65,0x64,0x0,0xCF,0xD0,0xCE
	.DB  0xC2,0xC5,0xD0,0xCA,0xC0,0x0,0x20,0xD2
	.DB  0xCE,0xDD,0xCB,0xCE,0x2D,0x31,0x38,0x31
	.DB  0x2E,0x0,0x20,0x20,0x25,0x69,0x60,0x43
	.DB  0x2E,0x0,0x20,0x25,0x69,0x3A,0x25,0x69
	.DB  0x3A,0x25,0x69,0x2E,0x0,0x20,0x25,0x69
	.DB  0x20,0x25,0x69,0x20,0x25,0x69,0x2E,0x0
	.DB  0x20,0x25,0x69,0x3E,0x25,0x69,0x3E,0x25
	.DB  0x69,0x2E,0x0
_0x2020003:
	.DB  0x80,0xC0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  _slaid
	.DW  _0x3*2

	.DW  0x02
	.DW  __base_y_G101
	.DW  _0x2020003*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,__SRAM_START
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x260

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.05.0 Professional
;Automatic Program Generator
; Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version :
;Date    : 17.12.2012
;Author  : NeVaDa
;Company :
;Comments:
;
;
;Chip type               : ATmega32
;Program type            : Application
;AVR Core Clock frequency: 16,000000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 512
;*****************************************************/
;
;#include <mega32.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;
;// 1 Wire Bus functions
;#asm
   .equ __wl_port=0x1B //   PORTA
   .equ __wl_bit=0     // 0
; 0000 001F #endasm
;// 1 Wire Bus interface functions
;#include <1wire.h>
;
;// DS1820 Temperature Sensor functions
;#include <ds18b20.h>
;
;#asm
   .equ __lcd_port=0x15 ;PORTC
; 0000 0028 #endasm
;// Alphanumeric LCD Module functions
;#include <alcd.h>
;
;// DS1302 Real Time Clock functions
;#asm
   .equ __ds1302_port=0x1B ;PORTA
   .equ __ds1302_io=1
   .equ __ds1302_sclk=2
   .equ __ds1302_rst=3
; 0000 0032 #endasm
;#include <ds1302.h>
;
;// Standard Input/Output functions
;#include <stdio.h>
;
;// maximum number of DS1820 devices
;// connected to the 1 Wire bus
;#define btn_m PIND.2
;#define btn_minus PIND.4
;#define btn_plus PIND.3
;#define btn_ok PIND.5
;#define led PORTB.0
;#define led_error PORTB.1
;#define MAX_DS18B20 8
;unsigned char ds18b20_devices;
;unsigned char ds18b20_rom_codes[MAX_DS18B20][9];
;float temper;
;int temper_int,temp_out;
;char lcd_buffer[80];  // 
;unsigned int t;//  
;unsigned char hour,h,minut,m,sek,s; //, , 
;unsigned char day,d,month,mo,year,y; //, , 
; unsigned char menu,n; //
;unsigned int slaid=100; //

	.DSEG
;
;void temperature(void) //     -
; 0000 004D {

	.CSEG
_temperature:
; 0000 004E temper=ds18b20_temperature(&ds18b20_rom_codes[0][0]);
	LDI  R30,LOW(_ds18b20_rom_codes)
	LDI  R31,HIGH(_ds18b20_rom_codes)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _ds18b20_temperature
	CALL SUBOPT_0x0
; 0000 004F temper_int=temper;
	CALL __CFD1
	MOVW R6,R30
; 0000 0050            if( temper > 1000 )
	CALL SUBOPT_0x1
	__GETD1N 0x447A0000
	CALL __CMPF12
	BREQ PC+2
	BRCC PC+3
	JMP  _0x4
; 0000 0051             {
; 0000 0052              temper = 40960-  temper;
	CALL SUBOPT_0x1
	__GETD1N 0x47200000
	CALL __SUBF12
	CALL SUBOPT_0x0
; 0000 0053              temper = -temper;
	CALL __ANEGF1
	STS  _temper,R30
	STS  _temper+1,R31
	STS  _temper+2,R22
	STS  _temper+3,R23
; 0000 0054             }
; 0000 0055       if(temper<125&&temper>-50){ temp_out=temper;}
_0x4:
	CALL SUBOPT_0x1
	__GETD1N 0x42FA0000
	CALL __CMPF12
	BRSH _0x6
	CALL SUBOPT_0x1
	__GETD1N 0xC2480000
	CALL __CMPF12
	BREQ PC+2
	BRCC PC+3
	JMP  _0x6
	RJMP _0x7
_0x6:
	RJMP _0x5
_0x7:
	LDS  R30,_temper
	LDS  R31,_temper+1
	LDS  R22,_temper+2
	LDS  R23,_temper+3
	CALL __CFD1
	MOVW R8,R30
; 0000 0056 }
_0x5:
	RET
;
; void time()
; 0000 0059  {
_time:
; 0000 005A    rtc_get_time(&hour,&minut,&sek); // 
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(12)
	LDI  R31,HIGH(12)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_sek)
	LDI  R31,HIGH(_sek)
	ST   -Y,R31
	ST   -Y,R30
	CALL _rtc_get_time
; 0000 005B    h=hour;
	MOV  R13,R4
; 0000 005C    m=minut;
	STS  _m,R12
; 0000 005D    s=sek;
	LDS  R30,_sek
	STS  _s,R30
; 0000 005E  }
	RET
;
;  void date()
; 0000 0061  {
_date:
; 0000 0062    rtc_get_date(&day,&month,&year); // 
	LDI  R30,LOW(_day)
	LDI  R31,HIGH(_day)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_month)
	LDI  R31,HIGH(_month)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_year)
	LDI  R31,HIGH(_year)
	ST   -Y,R31
	ST   -Y,R30
	CALL _rtc_get_date
; 0000 0063    d=day;
	LDS  R30,_day
	STS  _d,R30
; 0000 0064    mo=month;
	LDS  R30,_month
	STS  _mo,R30
; 0000 0065    y=year;
	LDS  R30,_year
	STS  _y,R30
; 0000 0066  }
	RET
;
; void lcd()
; 0000 0069  {
_lcd:
; 0000 006A   lcd_clear();   //  LCD
	CALL _lcd_clear
; 0000 006B     if(menu==0)
	LDS  R30,_menu
	CPI  R30,0
	BRNE _0x8
; 0000 006C     {
; 0000 006D      lcd_gotoxy(0,0);
	LDI  R30,LOW(0)
	CALL SUBOPT_0x2
; 0000 006E          sprintf(lcd_buffer,"%i>%i>%i", d,mo,y);
	__POINTW1FN _0x0,0
	CALL SUBOPT_0x3
	CALL SUBOPT_0x4
; 0000 006F      lcd_puts(lcd_buffer);  //    
; 0000 0070      lcd_gotoxy(4,1);              //
	CALL SUBOPT_0x5
; 0000 0071          sprintf(lcd_buffer,"%i:%i:%i", h,m,s);
	CALL SUBOPT_0x6
	CALL SUBOPT_0x4
; 0000 0072      lcd_puts(lcd_buffer);  //    
; 0000 0073 
; 0000 0074            lcd_gotoxy(9,0);              //
	LDI  R30,LOW(9)
	CALL SUBOPT_0x2
; 0000 0075         sprintf(lcd_buffer,"T=%d\xdfC",temp_out);  // 
	__POINTW1FN _0x0,18
	CALL SUBOPT_0x7
	CALL SUBOPT_0x8
; 0000 0076         lcd_puts(lcd_buffer);  //    
; 0000 0077      }
; 0000 0078      if(menu==1)
_0x8:
	LDS  R26,_menu
	CPI  R26,LOW(0x1)
	BRNE _0x9
; 0000 0079      {
; 0000 007A          lcd_gotoxy(5,0);
	LDI  R30,LOW(5)
	CALL SUBOPT_0x2
; 0000 007B          sprintf(lcd_buffer,"SET");
	__POINTW1FN _0x0,25
	CALL SUBOPT_0x9
; 0000 007C      lcd_puts(lcd_buffer);  //    
; 0000 007D      lcd_gotoxy(3,1);              //
	LDI  R30,LOW(3)
	CALL SUBOPT_0xA
; 0000 007E          sprintf(lcd_buffer,"TERMINAL");
	__POINTW1FN _0x0,29
	CALL SUBOPT_0x9
; 0000 007F      lcd_puts(lcd_buffer);  //    
; 0000 0080      delay_ms(500);
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	CALL SUBOPT_0xB
; 0000 0081      }
; 0000 0082      if(menu==2)
_0x9:
	LDS  R26,_menu
	CPI  R26,LOW(0x2)
	BRNE _0xA
; 0000 0083      {
; 0000 0084        if(n==0){ sprintf(lcd_buffer,"SET HOUR");}  // 
	LDS  R30,_n
	CPI  R30,0
	BRNE _0xB
	CALL SUBOPT_0xC
	__POINTW1FN _0x0,38
	CALL SUBOPT_0xD
; 0000 0085         if(n==1){ sprintf(lcd_buffer,"SET MINUT");}  // 
_0xB:
	LDS  R26,_n
	CPI  R26,LOW(0x1)
	BRNE _0xC
	CALL SUBOPT_0xC
	__POINTW1FN _0x0,47
	CALL SUBOPT_0xD
; 0000 0086          if(n==2){ sprintf(lcd_buffer,"SET SEKUND");}  // 
_0xC:
	LDS  R26,_n
	CPI  R26,LOW(0x2)
	BRNE _0xD
	CALL SUBOPT_0xC
	__POINTW1FN _0x0,57
	CALL SUBOPT_0xD
; 0000 0087         lcd_puts(lcd_buffer);  //    
_0xD:
	CALL SUBOPT_0xC
	CALL _lcd_puts
; 0000 0088          lcd_gotoxy(4,1);              //
	CALL SUBOPT_0x5
; 0000 0089       sprintf(lcd_buffer,"%i:%i:%i", hour,minut,sek);
	MOV  R30,R4
	CALL SUBOPT_0xE
	MOV  R30,R12
	CALL SUBOPT_0xE
	LDS  R30,_sek
	CALL SUBOPT_0xE
	LDI  R24,12
	CALL SUBOPT_0x4
; 0000 008A      lcd_puts(lcd_buffer);  //    
; 0000 008B      delay_ms(50);
	CALL SUBOPT_0xF
; 0000 008C      }
; 0000 008D          if(menu==3)
_0xA:
	LDS  R26,_menu
	CPI  R26,LOW(0x3)
	BRNE _0xE
; 0000 008E      {
; 0000 008F        if(n==0){ sprintf(lcd_buffer,"SET DAY");}  // 
	LDS  R30,_n
	CPI  R30,0
	BRNE _0xF
	CALL SUBOPT_0xC
	__POINTW1FN _0x0,68
	CALL SUBOPT_0xD
; 0000 0090         if(n==1){ sprintf(lcd_buffer,"SET MONTH");}  // 
_0xF:
	LDS  R26,_n
	CPI  R26,LOW(0x1)
	BRNE _0x10
	CALL SUBOPT_0xC
	__POINTW1FN _0x0,76
	CALL SUBOPT_0xD
; 0000 0091          if(n==2){ sprintf(lcd_buffer,"SET YEAR");}  // 
_0x10:
	LDS  R26,_n
	CPI  R26,LOW(0x2)
	BRNE _0x11
	CALL SUBOPT_0xC
	__POINTW1FN _0x0,86
	CALL SUBOPT_0xD
; 0000 0092         lcd_puts(lcd_buffer);  //    
_0x11:
	CALL SUBOPT_0xC
	CALL _lcd_puts
; 0000 0093          lcd_gotoxy(4,1);              //
	CALL SUBOPT_0x5
; 0000 0094       sprintf(lcd_buffer,"%i:%i:%i", day,month,year);
	LDS  R30,_day
	CALL SUBOPT_0xE
	LDS  R30,_month
	CALL SUBOPT_0xE
	LDS  R30,_year
	CALL SUBOPT_0xE
	LDI  R24,12
	CALL SUBOPT_0x4
; 0000 0095      lcd_puts(lcd_buffer);  //    
; 0000 0096      delay_ms(50);
	CALL SUBOPT_0xF
; 0000 0097      }
; 0000 0098               if(menu==4)
_0xE:
	LDS  R26,_menu
	CPI  R26,LOW(0x4)
	BRNE _0x12
; 0000 0099      {
; 0000 009A           sprintf(lcd_buffer,"LED DISPLAY");  // 
	CALL SUBOPT_0xC
	__POINTW1FN _0x0,95
	CALL SUBOPT_0x9
; 0000 009B         lcd_puts(lcd_buffer);  //    
; 0000 009C          lcd_gotoxy(4,1);              //
	LDI  R30,LOW(4)
	CALL SUBOPT_0xA
; 0000 009D       sprintf(lcd_buffer,"Time: %i",slaid/100);
	__POINTW1FN _0x0,107
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x10
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21U
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL SUBOPT_0x8
; 0000 009E      lcd_puts(lcd_buffer);  //    
; 0000 009F      delay_ms(50);
	CALL SUBOPT_0xF
; 0000 00A0      }
; 0000 00A1      if(menu==5)
_0x12:
	LDS  R26,_menu
	CPI  R26,LOW(0x5)
	BRNE _0x13
; 0000 00A2      {
; 0000 00A3         sprintf(lcd_buffer,"Press ok for    check display");  // 
	CALL SUBOPT_0xC
	__POINTW1FN _0x0,116
	CALL SUBOPT_0x9
; 0000 00A4         lcd_puts(lcd_buffer);  //    
; 0000 00A5 
; 0000 00A6      delay_ms(50);
	CALL SUBOPT_0xF
; 0000 00A7      }
; 0000 00A8  }
_0x13:
	RET
;
; void btn()
; 0000 00AB  {
_btn:
; 0000 00AC   if(btn_m==0&&menu==0){menu=1;}
	LDI  R26,0
	SBIC 0x10,2
	LDI  R26,1
	CPI  R26,LOW(0x0)
	BRNE _0x15
	LDS  R26,_menu
	CPI  R26,LOW(0x0)
	BREQ _0x16
_0x15:
	RJMP _0x14
_0x16:
	LDI  R30,LOW(1)
	STS  _menu,R30
; 0000 00AD   if(menu==1){if(btn_m!=0){menu=2;}}
_0x14:
	LDS  R26,_menu
	CPI  R26,LOW(0x1)
	BRNE _0x17
	SBIS 0x10,2
	RJMP _0x18
	LDI  R30,LOW(2)
	STS  _menu,R30
_0x18:
; 0000 00AE   if(btn_m==0&&menu!=0&&menu!=1){delay_ms(100);menu++;}
_0x17:
	LDI  R26,0
	SBIC 0x10,2
	LDI  R26,1
	CPI  R26,LOW(0x0)
	BRNE _0x1A
	LDS  R26,_menu
	CPI  R26,LOW(0x0)
	BREQ _0x1A
	CPI  R26,LOW(0x1)
	BRNE _0x1B
_0x1A:
	RJMP _0x19
_0x1B:
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL SUBOPT_0xB
	LDS  R30,_menu
	SUBI R30,-LOW(1)
	STS  _menu,R30
; 0000 00AF   if(menu>=6){menu=0;}
_0x19:
	LDS  R26,_menu
	CPI  R26,LOW(0x6)
	BRLO _0x1C
	LDI  R30,LOW(0)
	STS  _menu,R30
; 0000 00B0   if(btn_ok==0){delay_ms(10);n++;}
_0x1C:
	SBIC 0x10,5
	RJMP _0x1D
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL SUBOPT_0xB
	LDS  R30,_n
	SUBI R30,-LOW(1)
	STS  _n,R30
; 0000 00B1   if(n>=3){n=0;}
_0x1D:
	LDS  R26,_n
	CPI  R26,LOW(0x3)
	BRLO _0x1E
	LDI  R30,LOW(0)
	STS  _n,R30
; 0000 00B2 
; 0000 00B3   if(menu==2)
_0x1E:
	LDS  R26,_menu
	CPI  R26,LOW(0x2)
	BREQ PC+3
	JMP _0x1F
; 0000 00B4   {
; 0000 00B5    if(n==0)
	LDS  R30,_n
	CPI  R30,0
	BRNE _0x20
; 0000 00B6    {
; 0000 00B7     if(btn_plus==0){delay_ms(20);hour++;}
	SBIC 0x10,3
	RJMP _0x21
	CALL SUBOPT_0x11
	INC  R4
; 0000 00B8     if(btn_minus==0){delay_ms(20);hour--;}
_0x21:
	SBIC 0x10,4
	RJMP _0x22
	CALL SUBOPT_0x11
	DEC  R4
; 0000 00B9     if(hour>=24){hour=0;}
_0x22:
	LDI  R30,LOW(24)
	CP   R4,R30
	BRLO _0x23
	CLR  R4
; 0000 00BA    }
_0x23:
; 0000 00BB       if(n==1)
_0x20:
	LDS  R26,_n
	CPI  R26,LOW(0x1)
	BRNE _0x24
; 0000 00BC    {
; 0000 00BD     if(btn_plus==0){delay_ms(20);minut++;}
	SBIC 0x10,3
	RJMP _0x25
	CALL SUBOPT_0x11
	INC  R12
; 0000 00BE     if(btn_minus==0){delay_ms(20);minut--;}
_0x25:
	SBIC 0x10,4
	RJMP _0x26
	CALL SUBOPT_0x11
	DEC  R12
; 0000 00BF     if(minut>=60){minut=0;}
_0x26:
	LDI  R30,LOW(60)
	CP   R12,R30
	BRLO _0x27
	CLR  R12
; 0000 00C0    }
_0x27:
; 0000 00C1        if(n==2)
_0x24:
	LDS  R26,_n
	CPI  R26,LOW(0x2)
	BRNE _0x28
; 0000 00C2    {
; 0000 00C3     if(btn_plus==0){delay_ms(20);sek++;}
	SBIC 0x10,3
	RJMP _0x29
	CALL SUBOPT_0x11
	LDS  R30,_sek
	SUBI R30,-LOW(1)
	STS  _sek,R30
; 0000 00C4     if(btn_minus==0){delay_ms(20);sek--;}
_0x29:
	SBIC 0x10,4
	RJMP _0x2A
	CALL SUBOPT_0x11
	LDS  R30,_sek
	SUBI R30,LOW(1)
	STS  _sek,R30
; 0000 00C5     if(sek>=60){sek=0;}
_0x2A:
	LDS  R26,_sek
	CPI  R26,LOW(0x3C)
	BRLO _0x2B
	LDI  R30,LOW(0)
	STS  _sek,R30
; 0000 00C6    }
_0x2B:
; 0000 00C7    rtc_set_time(hour,minut,sek); // : , , 
_0x28:
	ST   -Y,R4
	ST   -Y,R12
	LDS  R30,_sek
	ST   -Y,R30
	CALL _rtc_set_time
; 0000 00C8   }
; 0000 00C9 
; 0000 00CA    if(menu==3)
_0x1F:
	LDS  R26,_menu
	CPI  R26,LOW(0x3)
	BREQ PC+3
	JMP _0x2C
; 0000 00CB   {
; 0000 00CC    if(n==0)
	LDS  R30,_n
	CPI  R30,0
	BRNE _0x2D
; 0000 00CD    {
; 0000 00CE     if(btn_plus==0){delay_ms(20);day++;}
	SBIC 0x10,3
	RJMP _0x2E
	CALL SUBOPT_0x11
	LDS  R30,_day
	SUBI R30,-LOW(1)
	STS  _day,R30
; 0000 00CF     if(btn_minus==0){delay_ms(10);day--;}
_0x2E:
	SBIC 0x10,4
	RJMP _0x2F
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL SUBOPT_0xB
	LDS  R30,_day
	SUBI R30,LOW(1)
	STS  _day,R30
; 0000 00D0     if(day>=32){day=1;}
_0x2F:
	LDS  R26,_day
	CPI  R26,LOW(0x20)
	BRLO _0x30
	LDI  R30,LOW(1)
	STS  _day,R30
; 0000 00D1    }
_0x30:
; 0000 00D2       if(n==1)
_0x2D:
	LDS  R26,_n
	CPI  R26,LOW(0x1)
	BRNE _0x31
; 0000 00D3    {
; 0000 00D4     if(btn_plus==0){delay_ms(20);month++;}
	SBIC 0x10,3
	RJMP _0x32
	CALL SUBOPT_0x11
	LDS  R30,_month
	SUBI R30,-LOW(1)
	STS  _month,R30
; 0000 00D5     if(btn_minus==0){delay_ms(20);month--;}
_0x32:
	SBIC 0x10,4
	RJMP _0x33
	CALL SUBOPT_0x11
	LDS  R30,_month
	SUBI R30,LOW(1)
	STS  _month,R30
; 0000 00D6     if(month>=13){month=1;}
_0x33:
	LDS  R26,_month
	CPI  R26,LOW(0xD)
	BRLO _0x34
	LDI  R30,LOW(1)
	STS  _month,R30
; 0000 00D7    }
_0x34:
; 0000 00D8        if(n==2)
_0x31:
	LDS  R26,_n
	CPI  R26,LOW(0x2)
	BRNE _0x35
; 0000 00D9    {
; 0000 00DA     if(btn_plus==0){delay_ms(20);year++;}
	SBIC 0x10,3
	RJMP _0x36
	CALL SUBOPT_0x11
	LDS  R30,_year
	SUBI R30,-LOW(1)
	STS  _year,R30
; 0000 00DB     if(btn_minus==0){delay_ms(20);year--;}
_0x36:
	SBIC 0x10,4
	RJMP _0x37
	CALL SUBOPT_0x11
	LDS  R30,_year
	SUBI R30,LOW(1)
	STS  _year,R30
; 0000 00DC    }
_0x37:
; 0000 00DD    rtc_set_date(day,month,year); // date
_0x35:
	LDS  R30,_day
	ST   -Y,R30
	LDS  R30,_month
	ST   -Y,R30
	LDS  R30,_year
	ST   -Y,R30
	CALL _rtc_set_date
; 0000 00DE   }
; 0000 00DF    if(menu==4)
_0x2C:
	LDS  R26,_menu
	CPI  R26,LOW(0x4)
	BRNE _0x38
; 0000 00E0   {
; 0000 00E1 
; 0000 00E2     if(btn_plus==0){delay_ms(20);slaid=slaid+100;}
	SBIC 0x10,3
	RJMP _0x39
	CALL SUBOPT_0x11
	CALL SUBOPT_0x12
	SUBI R30,LOW(-100)
	SBCI R31,HIGH(-100)
	CALL SUBOPT_0x13
; 0000 00E3     if(btn_minus==0){delay_ms(20);slaid=slaid-100;}
_0x39:
	SBIC 0x10,4
	RJMP _0x3A
	CALL SUBOPT_0x11
	CALL SUBOPT_0x12
	SUBI R30,LOW(100)
	SBCI R31,HIGH(100)
	CALL SUBOPT_0x13
; 0000 00E4     if(slaid>=1000||slaid<100){slaid=100;}
_0x3A:
	CALL SUBOPT_0x10
	CPI  R26,LOW(0x3E8)
	LDI  R30,HIGH(0x3E8)
	CPC  R27,R30
	BRSH _0x3C
	CALL SUBOPT_0x10
	CPI  R26,LOW(0x64)
	LDI  R30,HIGH(0x64)
	CPC  R27,R30
	BRSH _0x3B
_0x3C:
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL SUBOPT_0x13
; 0000 00E5 
; 0000 00E6   }
_0x3B:
; 0000 00E7      if(menu==5)
_0x38:
	LDS  R26,_menu
	CPI  R26,LOW(0x5)
	BRNE _0x3E
; 0000 00E8   {
; 0000 00E9 
; 0000 00EA     if(btn_ok==0)
	SBIC 0x10,5
	RJMP _0x3F
; 0000 00EB     {
; 0000 00EC     delay_ms(20);
	CALL SUBOPT_0x11
; 0000 00ED          lcd_clear();   //  LCD
	CALL _lcd_clear
; 0000 00EE         sprintf(lcd_buffer,"Display check   is started");  // 
	CALL SUBOPT_0xC
	__POINTW1FN _0x0,146
	CALL SUBOPT_0x9
; 0000 00EF         lcd_puts(lcd_buffer);  //    
; 0000 00F0         delay_ms(200);
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	CALL SUBOPT_0xB
; 0000 00F1         printf(""); //  
	__POINTW1FN _0x0,173
	CALL SUBOPT_0x14
; 0000 00F2         delay_ms(200);
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	CALL SUBOPT_0xB
; 0000 00F3     menu=0;
	LDI  R30,LOW(0)
	STS  _menu,R30
; 0000 00F4     }
; 0000 00F5 
; 0000 00F6   }
_0x3F:
; 0000 00F7  }
_0x3E:
	RET
;
; void out_usart()
; 0000 00FA  {
_out_usart:
; 0000 00FB      led=UCSRA.6;
	SBIC 0xB,6
	RJMP _0x40
	CBI  0x18,0
	RJMP _0x41
_0x40:
	SBI  0x18,0
_0x41:
; 0000 00FC      led_error=UCSRA.4;
	SBIC 0xB,4
	RJMP _0x42
	CBI  0x18,1
	RJMP _0x43
_0x42:
	SBI  0x18,1
_0x43:
; 0000 00FD        if(t<slaid) {printf(" -181.");} //  
	CALL SUBOPT_0x12
	CP   R10,R30
	CPC  R11,R31
	BRSH _0x44
	__POINTW1FN _0x0,182
	CALL SUBOPT_0x14
; 0000 00FE      led=UCSRA.6;
_0x44:
	SBIC 0xB,6
	RJMP _0x45
	CBI  0x18,0
	RJMP _0x46
_0x45:
	SBI  0x18,0
_0x46:
; 0000 00FF        if(t>=slaid&&t<slaid*2)
	CALL SUBOPT_0x12
	CP   R10,R30
	CPC  R11,R31
	BRLO _0x48
	CALL SUBOPT_0x15
	BRLO _0x49
_0x48:
	RJMP _0x47
_0x49:
; 0000 0100         {
; 0000 0101          printf("  %i`C.",temp_out); //   
	__POINTW1FN _0x0,194
	CALL SUBOPT_0x7
	CALL _printf
	ADIW R28,6
; 0000 0102          }
; 0000 0103      led=UCSRA.6;
_0x47:
	SBIC 0xB,6
	RJMP _0x4A
	CBI  0x18,0
	RJMP _0x4B
_0x4A:
	SBI  0x18,0
_0x4B:
; 0000 0104        if(t>=slaid*2&&t<slaid*3)
	CALL SUBOPT_0x15
	BRLO _0x4D
	CALL SUBOPT_0x16
	BRLO _0x4E
_0x4D:
	RJMP _0x4C
_0x4E:
; 0000 0105         {
; 0000 0106         printf(" %i:%i:%i.", h,m,s);
	CALL SUBOPT_0x17
	CALL _printf
	ADIW R28,14
; 0000 0107         delay_ms(20);
	CALL SUBOPT_0x11
; 0000 0108         printf(" %i %i %i.", h,m,s);
	__POINTW1FN _0x0,213
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x6
	CALL _printf
	ADIW R28,14
; 0000 0109         delay_ms(20);
	CALL SUBOPT_0x11
; 0000 010A         printf(" %i:%i:%i.", h,m,s);
	CALL SUBOPT_0x17
	CALL _printf
	ADIW R28,14
; 0000 010B         } //   
; 0000 010C      led=UCSRA.6;
_0x4C:
	SBIC 0xB,6
	RJMP _0x4F
	CBI  0x18,0
	RJMP _0x50
_0x4F:
	SBI  0x18,0
_0x50:
; 0000 010D        if(t>=slaid*3&&t<slaid*4)
	CALL SUBOPT_0x16
	BRLO _0x52
	CALL SUBOPT_0x18
	BRLO _0x53
_0x52:
	RJMP _0x51
_0x53:
; 0000 010E        {
; 0000 010F        printf(" %i>%i>%i.", d,mo,y);
	__POINTW1FN _0x0,224
	CALL SUBOPT_0x3
	CALL _printf
	ADIW R28,14
; 0000 0110        } //   
; 0000 0111      led=UCSRA.6;
_0x51:
	SBIC 0xB,6
	RJMP _0x54
	CBI  0x18,0
	RJMP _0x55
_0x54:
	SBI  0x18,0
_0x55:
; 0000 0112        if(t>=slaid*4)t=0;
	CALL SUBOPT_0x18
	BRLO _0x56
	CLR  R10
	CLR  R11
; 0000 0113  }
_0x56:
	RET
;// Timer 0 overflow interrupt service routine
;interrupt [TIM0_OVF] void timer0_ovf_isr(void)
; 0000 0116  {
_timer0_ovf_isr:
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0117   t++;
	MOVW R30,R10
	ADIW R30,1
	MOVW R10,R30
	SBIW R30,1
; 0000 0118  }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	RETI
;
;// Declare your global variables here
;
;void main(void)
; 0000 011D {
_main:
; 0000 011E // Declare your local variables here
; 0000 011F 
; 0000 0120 // Input/Output Ports initialization
; 0000 0121 // Port A initialization
; 0000 0122 // Func7=Out Func6=Out Func5=Out Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 0123 // State7=0 State6=0 State5=0 State4=P State3=P State2=P State1=P State0=T
; 0000 0124 PORTA=0x1E;
	LDI  R30,LOW(30)
	OUT  0x1B,R30
; 0000 0125 DDRA=0xE0;
	LDI  R30,LOW(224)
	OUT  0x1A,R30
; 0000 0126 
; 0000 0127 // Port B initialization
; 0000 0128 // Func7=In Func6=In Func5=In Func4=In Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 0129 // State7=T State6=T State5=T State4=T State3=0 State2=0 State1=0 State0=0
; 0000 012A PORTB=0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
; 0000 012B DDRB=0x0F;
	LDI  R30,LOW(15)
	OUT  0x17,R30
; 0000 012C 
; 0000 012D // Port C initialization
; 0000 012E // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 012F // State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
; 0000 0130 PORTC=0x00;
	LDI  R30,LOW(0)
	OUT  0x15,R30
; 0000 0131 DDRC=0xFF;
	LDI  R30,LOW(255)
	OUT  0x14,R30
; 0000 0132 
; 0000 0133 // Port D initialization
; 0000 0134 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 0135 // State7=P State6=P State5=P State4=P State3=P State2=P State1=T State0=T
; 0000 0136 PORTD=0xFC;
	LDI  R30,LOW(252)
	OUT  0x12,R30
; 0000 0137 DDRD=0x00;
	LDI  R30,LOW(0)
	OUT  0x11,R30
; 0000 0138 
; 0000 0139 // Timer/Counter 0 initialization
; 0000 013A // Clock source: System Clock
; 0000 013B // Clock value: 15,625 kHz
; 0000 013C // Mode: Normal top=0xFF
; 0000 013D // OC0 output: Disconnected
; 0000 013E TCCR0=0x05;
	LDI  R30,LOW(5)
	OUT  0x33,R30
; 0000 013F TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x32,R30
; 0000 0140 OCR0=0x00;
	OUT  0x3C,R30
; 0000 0141 
; 0000 0142 // Timer/Counter 1 initialization
; 0000 0143 // Clock source: System Clock
; 0000 0144 // Clock value: Timer1 Stopped
; 0000 0145 // Mode: Normal top=0xFFFF
; 0000 0146 // OC1A output: Discon.
; 0000 0147 // OC1B output: Discon.
; 0000 0148 // Noise Canceler: Off
; 0000 0149 // Input Capture on Falling Edge
; 0000 014A // Timer1 Overflow Interrupt: Off
; 0000 014B // Input Capture Interrupt: Off
; 0000 014C // Compare A Match Interrupt: Off
; 0000 014D // Compare B Match Interrupt: Off
; 0000 014E TCCR1A=0x00;
	OUT  0x2F,R30
; 0000 014F TCCR1B=0x00;
	OUT  0x2E,R30
; 0000 0150 TCNT1H=0x00;
	OUT  0x2D,R30
; 0000 0151 TCNT1L=0x00;
	OUT  0x2C,R30
; 0000 0152 ICR1H=0x00;
	OUT  0x27,R30
; 0000 0153 ICR1L=0x00;
	OUT  0x26,R30
; 0000 0154 OCR1AH=0x00;
	OUT  0x2B,R30
; 0000 0155 OCR1AL=0x00;
	OUT  0x2A,R30
; 0000 0156 OCR1BH=0x00;
	OUT  0x29,R30
; 0000 0157 OCR1BL=0x00;
	OUT  0x28,R30
; 0000 0158 
; 0000 0159 // Timer/Counter 2 initialization
; 0000 015A // Clock source: System Clock
; 0000 015B // Clock value: Timer2 Stopped
; 0000 015C // Mode: Normal top=0xFF
; 0000 015D // OC2 output: Disconnected
; 0000 015E ASSR=0x00;
	OUT  0x22,R30
; 0000 015F TCCR2=0x00;
	OUT  0x25,R30
; 0000 0160 TCNT2=0x00;
	OUT  0x24,R30
; 0000 0161 OCR2=0x00;
	OUT  0x23,R30
; 0000 0162 
; 0000 0163 // External Interrupt(s) initialization
; 0000 0164 // INT0: Off
; 0000 0165 // INT1: Off
; 0000 0166 // INT2: Off
; 0000 0167 MCUCR=0x00;
	OUT  0x35,R30
; 0000 0168 MCUCSR=0x00;
	OUT  0x34,R30
; 0000 0169 
; 0000 016A // Timer(s)/Counter(s) Interrupt(s) initialization
; 0000 016B TIMSK=0x01;
	LDI  R30,LOW(1)
	OUT  0x39,R30
; 0000 016C 
; 0000 016D // USART initialization
; 0000 016E // Communication Parameters: 8 Data, 1 Stop, No Parity
; 0000 016F // USART Receiver: On
; 0000 0170 // USART Transmitter: On
; 0000 0171 // USART Mode: Asynchronous
; 0000 0172 // USART Baud Rate: 9600
; 0000 0173 UCSRA=0x00;
	LDI  R30,LOW(0)
	OUT  0xB,R30
; 0000 0174 UCSRB=0x18;
	LDI  R30,LOW(24)
	OUT  0xA,R30
; 0000 0175 UCSRC=0x86;
	LDI  R30,LOW(134)
	OUT  0x20,R30
; 0000 0176 UBRRH=0x00;
	LDI  R30,LOW(0)
	OUT  0x20,R30
; 0000 0177 UBRRL=0x67;
	LDI  R30,LOW(103)
	OUT  0x9,R30
; 0000 0178         UCSRB.4=0;
	CBI  0xA,4
; 0000 0179 // Analog Comparator initialization
; 0000 017A // Analog Comparator: Off
; 0000 017B // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 017C ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
; 0000 017D SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
; 0000 017E 
; 0000 017F // ADC initialization
; 0000 0180 // ADC disabled
; 0000 0181 ADCSRA=0x00;
	OUT  0x6,R30
; 0000 0182 
; 0000 0183 // SPI initialization
; 0000 0184 // SPI disabled
; 0000 0185 SPCR=0x00;
	OUT  0xD,R30
; 0000 0186 
; 0000 0187 // TWI initialization
; 0000 0188 // TWI disabled
; 0000 0189 TWCR=0x00;
	OUT  0x36,R30
; 0000 018A 
; 0000 018B // DS1302 Real Time Clock initialization
; 0000 018C // Trickle charger: On
; 0000 018D // Trickle charge resistor: 2K
; 0000 018E // Trickle charge diode(s): 2
; 0000 018F rtc_init(1,2,1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _rtc_init
; 0000 0190 
; 0000 0191 // 1 Wire Bus initialization
; 0000 0192 // 1 Wire Data port: PORTA
; 0000 0193 // 1 Wire Data bit: 0
; 0000 0194 // Note: 1 Wire port settings must be specified in the
; 0000 0195 // Project|Configure|C Compiler|Libraries|1 Wire IDE menu.
; 0000 0196 //w1_init();
; 0000 0197 ds18b20_devices=w1_search(0xf0,ds18b20_rom_codes);
	LDI  R30,LOW(240)
	ST   -Y,R30
	LDI  R30,LOW(_ds18b20_rom_codes)
	LDI  R31,HIGH(_ds18b20_rom_codes)
	ST   -Y,R31
	ST   -Y,R30
	CALL _w1_search
	MOV  R5,R30
; 0000 0198 ds18b20_init(0,-35,35,DS18B20_12BIT_RES);  //    12  
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(221)
	ST   -Y,R30
	LDI  R30,LOW(35)
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	RCALL _ds18b20_init
; 0000 0199 // Alphanumeric LCD initialization
; 0000 019A // Connections specified in the
; 0000 019B // Project|Configure|C Compiler|Libraries|Alphanumeric LCD menu:
; 0000 019C // RS - PORTC Bit 0
; 0000 019D // RD - PORTC Bit 1
; 0000 019E // EN - PORTC Bit 2
; 0000 019F // D4 - PORTC Bit 3
; 0000 01A0 // D5 - PORTC Bit 4
; 0000 01A1 // D6 - PORTC Bit 5
; 0000 01A2 // D7 - PORTC Bit 6
; 0000 01A3 // Characters/line: 16
; 0000 01A4 lcd_init(16);
	LDI  R30,LOW(16)
	ST   -Y,R30
	CALL _lcd_init
; 0000 01A5 
; 0000 01A6 // Global enable interrupts
; 0000 01A7 #asm("sei")
	sei
; 0000 01A8 
; 0000 01A9 while (1)
_0x59:
; 0000 01AA       {
; 0000 01AB         btn();
	RCALL _btn
; 0000 01AC        if(menu==0)
	LDS  R30,_menu
	CPI  R30,0
	BRNE _0x5C
; 0000 01AD        {
; 0000 01AE         time(); //   
	RCALL _time
; 0000 01AF         date(); //   
	RCALL _date
; 0000 01B0         temperature(); //   
	RCALL _temperature
; 0000 01B1         }
; 0000 01B2         delay_ms(5);
_0x5C:
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	CALL SUBOPT_0xB
; 0000 01B3         out_usart();
	RCALL _out_usart
; 0000 01B4         lcd();
	RCALL _lcd
; 0000 01B5         };
	RJMP _0x59
; 0000 01B6 
; 0000 01B7 }
_0x5D:
	RJMP _0x5D

	.CSEG
_ds18b20_select:
	ST   -Y,R17
	CALL _w1_init
	CPI  R30,0
	BRNE _0x2000003
	LDI  R30,LOW(0)
	LDD  R17,Y+0
	JMP  _0x20E0003
_0x2000003:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	SBIW R30,0
	BREQ _0x2000004
	LDI  R30,LOW(85)
	ST   -Y,R30
	CALL _w1_write
	LDI  R17,LOW(0)
_0x2000006:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	LD   R30,X+
	STD  Y+1,R26
	STD  Y+1+1,R27
	ST   -Y,R30
	CALL _w1_write
	SUBI R17,-LOW(1)
	CPI  R17,8
	BRLO _0x2000006
	RJMP _0x2000008
_0x2000004:
	LDI  R30,LOW(204)
	ST   -Y,R30
	CALL _w1_write
_0x2000008:
	LDI  R30,LOW(1)
	LDD  R17,Y+0
	JMP  _0x20E0003
_ds18b20_read_spd:
	CALL __SAVELOCR4
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	CALL SUBOPT_0x19
	BRNE _0x2000009
	LDI  R30,LOW(0)
	CALL __LOADLOCR4
	JMP  _0x20E0006
_0x2000009:
	LDI  R30,LOW(190)
	ST   -Y,R30
	CALL _w1_write
	LDI  R17,LOW(0)
	__POINTWRM 18,19,___ds18b20_scratch_pad
_0x200000B:
	PUSH R19
	PUSH R18
	__ADDWRN 18,19,1
	CALL _w1_read
	POP  R26
	POP  R27
	ST   X,R30
	SUBI R17,-LOW(1)
	CPI  R17,9
	BRLO _0x200000B
	LDI  R30,LOW(___ds18b20_scratch_pad)
	LDI  R31,HIGH(___ds18b20_scratch_pad)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(9)
	ST   -Y,R30
	CALL _w1_dow_crc8
	CALL __LNEGB1
	CALL __LOADLOCR4
	JMP  _0x20E0006
_ds18b20_temperature:
	ST   -Y,R17
	CALL SUBOPT_0x1A
	BRNE _0x200000D
	CALL SUBOPT_0x1B
	JMP  _0x20E0003
_0x200000D:
	__GETB2MN ___ds18b20_scratch_pad,4
	LDI  R27,0
	LDI  R30,LOW(5)
	CALL __ASRW12
	ANDI R30,LOW(0x3)
	MOV  R17,R30
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	CALL SUBOPT_0x19
	BRNE _0x200000E
	CALL SUBOPT_0x1B
	JMP  _0x20E0003
_0x200000E:
	LDI  R30,LOW(68)
	ST   -Y,R30
	CALL _w1_write
	MOV  R30,R17
	LDI  R26,LOW(_conv_delay_G100*2)
	LDI  R27,HIGH(_conv_delay_G100*2)
	CALL SUBOPT_0x1C
	CALL SUBOPT_0xB
	CALL SUBOPT_0x1A
	BRNE _0x200000F
	CALL SUBOPT_0x1B
	JMP  _0x20E0003
_0x200000F:
	CALL _w1_init
	MOV  R30,R17
	LDI  R26,LOW(_bit_mask_G100*2)
	LDI  R27,HIGH(_bit_mask_G100*2)
	CALL SUBOPT_0x1C
	LDS  R26,___ds18b20_scratch_pad
	LDS  R27,___ds18b20_scratch_pad+1
	AND  R30,R26
	AND  R31,R27
	CALL __CWD1
	CALL __CDF1
	__GETD2N 0x3D800000
	CALL __MULF12
	LDD  R17,Y+0
	JMP  _0x20E0003
_ds18b20_init:
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	CALL SUBOPT_0x19
	BRNE _0x2000010
	LDI  R30,LOW(0)
	JMP  _0x20E0002
_0x2000010:
	LD   R30,Y
	SWAP R30
	ANDI R30,0xF0
	LSL  R30
	ORI  R30,LOW(0x1F)
	ST   Y,R30
	LDI  R30,LOW(78)
	ST   -Y,R30
	CALL _w1_write
	LDD  R30,Y+1
	ST   -Y,R30
	CALL _w1_write
	LDD  R30,Y+2
	ST   -Y,R30
	CALL _w1_write
	LD   R30,Y
	ST   -Y,R30
	CALL _w1_write
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	ST   -Y,R31
	ST   -Y,R30
	RCALL _ds18b20_read_spd
	CPI  R30,0
	BRNE _0x2000011
	LDI  R30,LOW(0)
	JMP  _0x20E0002
_0x2000011:
	__GETB2MN ___ds18b20_scratch_pad,3
	LDD  R30,Y+2
	CP   R30,R26
	BRNE _0x2000013
	__GETB2MN ___ds18b20_scratch_pad,2
	LDD  R30,Y+1
	CP   R30,R26
	BRNE _0x2000013
	__GETB2MN ___ds18b20_scratch_pad,4
	LD   R30,Y
	CP   R30,R26
	BREQ _0x2000012
_0x2000013:
	LDI  R30,LOW(0)
	JMP  _0x20E0002
_0x2000012:
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	CALL SUBOPT_0x19
	BRNE _0x2000015
	LDI  R30,LOW(0)
	JMP  _0x20E0002
_0x2000015:
	LDI  R30,LOW(72)
	ST   -Y,R30
	CALL _w1_write
	LDI  R30,LOW(15)
	LDI  R31,HIGH(15)
	CALL SUBOPT_0xB
	CALL _w1_init
	JMP  _0x20E0002
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.DSEG

	.CSEG
__lcd_write_nibble_G101:
	LD   R30,Y
	ANDI R30,LOW(0x10)
	BREQ _0x2020004
	SBI  0x15,3
	RJMP _0x2020005
_0x2020004:
	CBI  0x15,3
_0x2020005:
	LD   R30,Y
	ANDI R30,LOW(0x20)
	BREQ _0x2020006
	SBI  0x15,4
	RJMP _0x2020007
_0x2020006:
	CBI  0x15,4
_0x2020007:
	LD   R30,Y
	ANDI R30,LOW(0x40)
	BREQ _0x2020008
	SBI  0x15,5
	RJMP _0x2020009
_0x2020008:
	CBI  0x15,5
_0x2020009:
	LD   R30,Y
	ANDI R30,LOW(0x80)
	BREQ _0x202000A
	SBI  0x15,6
	RJMP _0x202000B
_0x202000A:
	CBI  0x15,6
_0x202000B:
	__DELAY_USB 11
	SBI  0x15,2
	__DELAY_USB 27
	CBI  0x15,2
	__DELAY_USB 27
	JMP  _0x20E0004
__lcd_write_data:
	LD   R30,Y
	ST   -Y,R30
	RCALL __lcd_write_nibble_G101
    ld    r30,y
    swap  r30
    st    y,r30
	LD   R30,Y
	ST   -Y,R30
	RCALL __lcd_write_nibble_G101
	__DELAY_USW 200
	JMP  _0x20E0004
_lcd_gotoxy:
	LD   R30,Y
	LDI  R31,0
	SUBI R30,LOW(-__base_y_G101)
	SBCI R31,HIGH(-__base_y_G101)
	LD   R30,Z
	LDD  R26,Y+1
	ADD  R30,R26
	ST   -Y,R30
	RCALL __lcd_write_data
	LDD  R30,Y+1
	STS  __lcd_x,R30
	LD   R30,Y
	STS  __lcd_y,R30
	JMP  _0x20E0007
_lcd_clear:
	LDI  R30,LOW(2)
	CALL SUBOPT_0x1D
	LDI  R30,LOW(12)
	ST   -Y,R30
	RCALL __lcd_write_data
	LDI  R30,LOW(1)
	CALL SUBOPT_0x1D
	LDI  R30,LOW(0)
	STS  __lcd_y,R30
	STS  __lcd_x,R30
	RET
_lcd_putchar:
	LD   R26,Y
	CPI  R26,LOW(0xA)
	BREQ _0x2020011
	LDS  R30,__lcd_maxx
	LDS  R26,__lcd_x
	CP   R26,R30
	BRLO _0x2020010
_0x2020011:
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDS  R30,__lcd_y
	SUBI R30,-LOW(1)
	STS  __lcd_y,R30
	ST   -Y,R30
	RCALL _lcd_gotoxy
	LD   R26,Y
	CPI  R26,LOW(0xA)
	BRNE _0x2020013
	JMP  _0x20E0004
_0x2020013:
_0x2020010:
	LDS  R30,__lcd_x
	SUBI R30,-LOW(1)
	STS  __lcd_x,R30
	SBI  0x15,0
	LD   R30,Y
	ST   -Y,R30
	RCALL __lcd_write_data
	CBI  0x15,0
	JMP  _0x20E0004
_lcd_puts:
	ST   -Y,R17
_0x2020014:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	LD   R30,X+
	STD  Y+1,R26
	STD  Y+1+1,R27
	MOV  R17,R30
	CPI  R30,0
	BREQ _0x2020016
	ST   -Y,R17
	RCALL _lcd_putchar
	RJMP _0x2020014
_0x2020016:
	LDD  R17,Y+0
	JMP  _0x20E0003
_lcd_init:
	SBI  0x14,3
	SBI  0x14,4
	SBI  0x14,5
	SBI  0x14,6
	SBI  0x14,2
	SBI  0x14,0
	SBI  0x14,1
	CBI  0x15,2
	CBI  0x15,0
	CBI  0x15,1
	LD   R30,Y
	STS  __lcd_maxx,R30
	SUBI R30,-LOW(128)
	__PUTB1MN __base_y_G101,2
	LD   R30,Y
	SUBI R30,-LOW(192)
	__PUTB1MN __base_y_G101,3
	CALL SUBOPT_0x11
	CALL SUBOPT_0x1E
	CALL SUBOPT_0x1E
	CALL SUBOPT_0x1E
	LDI  R30,LOW(32)
	ST   -Y,R30
	RCALL __lcd_write_nibble_G101
	__DELAY_USW 400
	LDI  R30,LOW(40)
	ST   -Y,R30
	RCALL __lcd_write_data
	LDI  R30,LOW(4)
	ST   -Y,R30
	RCALL __lcd_write_data
	LDI  R30,LOW(133)
	ST   -Y,R30
	RCALL __lcd_write_data
	LDI  R30,LOW(6)
	ST   -Y,R30
	RCALL __lcd_write_data
	RCALL _lcd_clear
	JMP  _0x20E0004

	.CSEG
_ds1302_rst0_G102:
	cbi  __ds1302_port,__ds1302_rst
	__DELAY_USB 27
	RET
_ds1302_write0_G102:
    sbi  __ds1302_port-1,__ds1302_sclk
    sbi  __ds1302_port-1,__ds1302_io
    sbi  __ds1302_port-1,__ds1302_rst
    sbi  __ds1302_port,__ds1302_rst
	__DELAY_USB 27
	LD   R30,Y
	ST   -Y,R30
	RCALL _ds1302_write1_G102
	JMP  _0x20E0004
_ds1302_write1_G102:
    ld   r30,y+
    ldi  r26,8
ds1302_write2:
    ror  r30
    cbi  __ds1302_port,__ds1302_io
    brcc ds1302_write3
    sbi  __ds1302_port,__ds1302_io
ds1302_write3:
    nop
    nop
    nop
    nop
    sbi  __ds1302_port,__ds1302_sclk
	__DELAY_USB 11
	cbi  __ds1302_port,__ds1302_sclk
	__DELAY_USB 11
    dec  r26
    brne ds1302_write2
    ret
_ds1302_read:
	LD   R30,Y
	ORI  R30,1
	ST   -Y,R30
	CALL _ds1302_write0_G102
    cbi  __ds1302_port,__ds1302_io
    cbi  __ds1302_port-1,__ds1302_io
    ldi  r26,8
ds1302_read0:
    clc
    sbic __ds1302_port-2,__ds1302_io
    sec
    ror  r30
    sbi  __ds1302_port,__ds1302_sclk
	__DELAY_USB 11
	cbi  __ds1302_port,__ds1302_sclk
	__DELAY_USB 11
    dec  r26
    brne ds1302_read0
	CALL _ds1302_rst0_G102
	RJMP _0x20E0004
_ds1302_write:
	LDD  R30,Y+1
	ANDI R30,0xFE
	ST   -Y,R30
	CALL _ds1302_write0_G102
	LD   R30,Y
	ST   -Y,R30
	CALL _ds1302_write1_G102
	CALL _ds1302_rst0_G102
_0x20E0007:
	ADIW R28,2
	RET
_rtc_init:
	LD   R30,Y
	ANDI R30,LOW(0x3)
	ST   Y,R30
	LDD  R30,Y+2
	CPI  R30,0
	BREQ _0x2040003
	LD   R30,Y
	ORI  R30,LOW(0xA0)
	ST   Y,R30
_0x2040003:
	LDD  R26,Y+1
	CPI  R26,LOW(0x1)
	BRNE _0x2040004
	LD   R30,Y
	ORI  R30,4
	RJMP _0x2040008
_0x2040004:
	LDD  R26,Y+1
	CPI  R26,LOW(0x2)
	BRNE _0x2040006
	LD   R30,Y
	ORI  R30,8
	RJMP _0x2040008
_0x2040006:
	LDI  R30,LOW(0)
_0x2040008:
	ST   Y,R30
	CALL SUBOPT_0x1F
	LDI  R30,LOW(144)
	ST   -Y,R30
	LDD  R30,Y+1
	CALL SUBOPT_0x20
	RJMP _0x20E0003
_rtc_get_time:
	LDI  R30,LOW(133)
	CALL SUBOPT_0x21
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ST   X,R30
	LDI  R30,LOW(131)
	CALL SUBOPT_0x21
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ST   X,R30
	LDI  R30,LOW(129)
	RJMP _0x20E0005
_rtc_set_time:
	CALL SUBOPT_0x1F
	LDI  R30,LOW(132)
	CALL SUBOPT_0x22
	LDI  R30,LOW(130)
	CALL SUBOPT_0x23
	LDI  R30,LOW(128)
	CALL SUBOPT_0x24
	RJMP _0x20E0003
_rtc_get_date:
	LDI  R30,LOW(135)
	CALL SUBOPT_0x21
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ST   X,R30
	LDI  R30,LOW(137)
	CALL SUBOPT_0x21
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ST   X,R30
	LDI  R30,LOW(141)
_0x20E0005:
	ST   -Y,R30
	RCALL _ds1302_read
	ST   -Y,R30
	CALL _bcd2bin
	LD   R26,Y
	LDD  R27,Y+1
	ST   X,R30
_0x20E0006:
	ADIW R28,6
	RET
_rtc_set_date:
	CALL SUBOPT_0x1F
	LDI  R30,LOW(134)
	CALL SUBOPT_0x22
	LDI  R30,LOW(136)
	CALL SUBOPT_0x23
	LDI  R30,LOW(140)
	CALL SUBOPT_0x24
	RJMP _0x20E0003
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG
_putchar:
putchar0:
     sbis usr,udre
     rjmp putchar0
     ld   r30,y
     out  udr,r30
_0x20E0004:
	ADIW R28,1
	RET
_put_usart_G103:
	LDD  R30,Y+2
	ST   -Y,R30
	RCALL _putchar
	LD   R26,Y
	LDD  R27,Y+1
	CALL SUBOPT_0x25
_0x20E0003:
	ADIW R28,3
	RET
_put_buff_G103:
	ST   -Y,R17
	ST   -Y,R16
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,2
	CALL __GETW1P
	SBIW R30,0
	BREQ _0x2060010
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,4
	CALL __GETW1P
	MOVW R16,R30
	SBIW R30,0
	BREQ _0x2060012
	__CPWRN 16,17,2
	BRLO _0x2060013
	MOVW R30,R16
	SBIW R30,1
	MOVW R16,R30
	__PUTW1SNS 2,4
_0x2060012:
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,2
	CALL SUBOPT_0x25
	SBIW R30,1
	LDD  R26,Y+4
	STD  Z+0,R26
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	CALL __GETW1P
	TST  R31
	BRMI _0x2060014
	CALL SUBOPT_0x25
_0x2060014:
_0x2060013:
	RJMP _0x2060015
_0x2060010:
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	ST   X+,R30
	ST   X,R31
_0x2060015:
	LDD  R17,Y+1
	LDD  R16,Y+0
_0x20E0002:
	ADIW R28,5
	RET
__print_G103:
	SBIW R28,6
	CALL __SAVELOCR6
	LDI  R17,0
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   X+,R30
	ST   X,R31
_0x2060016:
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	ADIW R30,1
	STD  Y+18,R30
	STD  Y+18+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R18,R30
	CPI  R30,0
	BRNE PC+3
	JMP _0x2060018
	MOV  R30,R17
	CPI  R30,0
	BRNE _0x206001C
	CPI  R18,37
	BRNE _0x206001D
	LDI  R17,LOW(1)
	RJMP _0x206001E
_0x206001D:
	CALL SUBOPT_0x26
_0x206001E:
	RJMP _0x206001B
_0x206001C:
	CPI  R30,LOW(0x1)
	BRNE _0x206001F
	CPI  R18,37
	BRNE _0x2060020
	CALL SUBOPT_0x26
	RJMP _0x20600C9
_0x2060020:
	LDI  R17,LOW(2)
	LDI  R20,LOW(0)
	LDI  R16,LOW(0)
	CPI  R18,45
	BRNE _0x2060021
	LDI  R16,LOW(1)
	RJMP _0x206001B
_0x2060021:
	CPI  R18,43
	BRNE _0x2060022
	LDI  R20,LOW(43)
	RJMP _0x206001B
_0x2060022:
	CPI  R18,32
	BRNE _0x2060023
	LDI  R20,LOW(32)
	RJMP _0x206001B
_0x2060023:
	RJMP _0x2060024
_0x206001F:
	CPI  R30,LOW(0x2)
	BRNE _0x2060025
_0x2060024:
	LDI  R21,LOW(0)
	LDI  R17,LOW(3)
	CPI  R18,48
	BRNE _0x2060026
	ORI  R16,LOW(128)
	RJMP _0x206001B
_0x2060026:
	RJMP _0x2060027
_0x2060025:
	CPI  R30,LOW(0x3)
	BREQ PC+3
	JMP _0x206001B
_0x2060027:
	CPI  R18,48
	BRLO _0x206002A
	CPI  R18,58
	BRLO _0x206002B
_0x206002A:
	RJMP _0x2060029
_0x206002B:
	LDI  R26,LOW(10)
	MUL  R21,R26
	MOV  R21,R0
	MOV  R30,R18
	SUBI R30,LOW(48)
	ADD  R21,R30
	RJMP _0x206001B
_0x2060029:
	MOV  R30,R18
	CPI  R30,LOW(0x63)
	BRNE _0x206002F
	CALL SUBOPT_0x27
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	LDD  R26,Z+4
	ST   -Y,R26
	CALL SUBOPT_0x28
	RJMP _0x2060030
_0x206002F:
	CPI  R30,LOW(0x73)
	BRNE _0x2060032
	CALL SUBOPT_0x27
	CALL SUBOPT_0x29
	CALL _strlen
	MOV  R17,R30
	RJMP _0x2060033
_0x2060032:
	CPI  R30,LOW(0x70)
	BRNE _0x2060035
	CALL SUBOPT_0x27
	CALL SUBOPT_0x29
	CALL _strlenf
	MOV  R17,R30
	ORI  R16,LOW(8)
_0x2060033:
	ORI  R16,LOW(2)
	ANDI R16,LOW(127)
	LDI  R19,LOW(0)
	RJMP _0x2060036
_0x2060035:
	CPI  R30,LOW(0x64)
	BREQ _0x2060039
	CPI  R30,LOW(0x69)
	BRNE _0x206003A
_0x2060039:
	ORI  R16,LOW(4)
	RJMP _0x206003B
_0x206003A:
	CPI  R30,LOW(0x75)
	BRNE _0x206003C
_0x206003B:
	LDI  R30,LOW(_tbl10_G103*2)
	LDI  R31,HIGH(_tbl10_G103*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(5)
	RJMP _0x206003D
_0x206003C:
	CPI  R30,LOW(0x58)
	BRNE _0x206003F
	ORI  R16,LOW(8)
	RJMP _0x2060040
_0x206003F:
	CPI  R30,LOW(0x78)
	BREQ PC+3
	JMP _0x2060071
_0x2060040:
	LDI  R30,LOW(_tbl16_G103*2)
	LDI  R31,HIGH(_tbl16_G103*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(4)
_0x206003D:
	SBRS R16,2
	RJMP _0x2060042
	CALL SUBOPT_0x27
	CALL SUBOPT_0x2A
	LDD  R26,Y+11
	TST  R26
	BRPL _0x2060043
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	CALL __ANEGW1
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDI  R20,LOW(45)
_0x2060043:
	CPI  R20,0
	BREQ _0x2060044
	SUBI R17,-LOW(1)
	RJMP _0x2060045
_0x2060044:
	ANDI R16,LOW(251)
_0x2060045:
	RJMP _0x2060046
_0x2060042:
	CALL SUBOPT_0x27
	CALL SUBOPT_0x2A
_0x2060046:
_0x2060036:
	SBRC R16,0
	RJMP _0x2060047
_0x2060048:
	CP   R17,R21
	BRSH _0x206004A
	SBRS R16,7
	RJMP _0x206004B
	SBRS R16,2
	RJMP _0x206004C
	ANDI R16,LOW(251)
	MOV  R18,R20
	SUBI R17,LOW(1)
	RJMP _0x206004D
_0x206004C:
	LDI  R18,LOW(48)
_0x206004D:
	RJMP _0x206004E
_0x206004B:
	LDI  R18,LOW(32)
_0x206004E:
	CALL SUBOPT_0x26
	SUBI R21,LOW(1)
	RJMP _0x2060048
_0x206004A:
_0x2060047:
	MOV  R19,R17
	SBRS R16,1
	RJMP _0x206004F
_0x2060050:
	CPI  R19,0
	BREQ _0x2060052
	SBRS R16,3
	RJMP _0x2060053
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LPM  R18,Z+
	STD  Y+6,R30
	STD  Y+6+1,R31
	RJMP _0x2060054
_0x2060053:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R18,X+
	STD  Y+6,R26
	STD  Y+6+1,R27
_0x2060054:
	CALL SUBOPT_0x26
	CPI  R21,0
	BREQ _0x2060055
	SUBI R21,LOW(1)
_0x2060055:
	SUBI R19,LOW(1)
	RJMP _0x2060050
_0x2060052:
	RJMP _0x2060056
_0x206004F:
_0x2060058:
	LDI  R18,LOW(48)
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	CALL __GETW1PF
	STD  Y+8,R30
	STD  Y+8+1,R31
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,2
	STD  Y+6,R30
	STD  Y+6+1,R31
_0x206005A:
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	CP   R26,R30
	CPC  R27,R31
	BRLO _0x206005C
	SUBI R18,-LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+10,R30
	STD  Y+10+1,R31
	RJMP _0x206005A
_0x206005C:
	CPI  R18,58
	BRLO _0x206005D
	SBRS R16,3
	RJMP _0x206005E
	SUBI R18,-LOW(7)
	RJMP _0x206005F
_0x206005E:
	SUBI R18,-LOW(39)
_0x206005F:
_0x206005D:
	SBRC R16,4
	RJMP _0x2060061
	CPI  R18,49
	BRSH _0x2060063
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,1
	BRNE _0x2060062
_0x2060063:
	RJMP _0x20600CA
_0x2060062:
	CP   R21,R19
	BRLO _0x2060067
	SBRS R16,0
	RJMP _0x2060068
_0x2060067:
	RJMP _0x2060066
_0x2060068:
	LDI  R18,LOW(32)
	SBRS R16,7
	RJMP _0x2060069
	LDI  R18,LOW(48)
_0x20600CA:
	ORI  R16,LOW(16)
	SBRS R16,2
	RJMP _0x206006A
	ANDI R16,LOW(251)
	ST   -Y,R20
	CALL SUBOPT_0x28
	CPI  R21,0
	BREQ _0x206006B
	SUBI R21,LOW(1)
_0x206006B:
_0x206006A:
_0x2060069:
_0x2060061:
	CALL SUBOPT_0x26
	CPI  R21,0
	BREQ _0x206006C
	SUBI R21,LOW(1)
_0x206006C:
_0x2060066:
	SUBI R19,LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,2
	BRLO _0x2060059
	RJMP _0x2060058
_0x2060059:
_0x2060056:
	SBRS R16,0
	RJMP _0x206006D
_0x206006E:
	CPI  R21,0
	BREQ _0x2060070
	SUBI R21,LOW(1)
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL SUBOPT_0x28
	RJMP _0x206006E
_0x2060070:
_0x206006D:
_0x2060071:
_0x2060030:
_0x20600C9:
	LDI  R17,LOW(0)
_0x206001B:
	RJMP _0x2060016
_0x2060018:
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	CALL __GETW1P
	CALL __LOADLOCR6
	ADIW R28,20
	RET
_sprintf:
	PUSH R15
	MOV  R15,R24
	SBIW R28,6
	CALL __SAVELOCR4
	CALL SUBOPT_0x2B
	SBIW R30,0
	BRNE _0x2060072
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	RJMP _0x20E0001
_0x2060072:
	MOVW R26,R28
	ADIW R26,6
	CALL __ADDW2R15
	MOVW R16,R26
	CALL SUBOPT_0x2B
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R30,LOW(0)
	STD  Y+8,R30
	STD  Y+8+1,R30
	MOVW R26,R28
	ADIW R26,10
	CALL SUBOPT_0x2C
	LDI  R30,LOW(_put_buff_G103)
	LDI  R31,HIGH(_put_buff_G103)
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,10
	ST   -Y,R31
	ST   -Y,R30
	RCALL __print_G103
	MOVW R18,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LDI  R30,LOW(0)
	ST   X,R30
	MOVW R30,R18
_0x20E0001:
	CALL __LOADLOCR4
	ADIW R28,10
	POP  R15
	RET
_printf:
	PUSH R15
	MOV  R15,R24
	SBIW R28,6
	ST   -Y,R17
	ST   -Y,R16
	MOVW R26,R28
	ADIW R26,4
	CALL __ADDW2R15
	MOVW R16,R26
	LDI  R30,LOW(0)
	STD  Y+4,R30
	STD  Y+4+1,R30
	STD  Y+6,R30
	STD  Y+6+1,R30
	MOVW R26,R28
	ADIW R26,8
	CALL SUBOPT_0x2C
	LDI  R30,LOW(_put_usart_G103)
	LDI  R31,HIGH(_put_usart_G103)
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,8
	ST   -Y,R31
	ST   -Y,R30
	RCALL __print_G103
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,8
	POP  R15
	RET

	.CSEG
_bcd2bin:
    ld   r30,y
    swap r30
    andi r30,0xf
    mov  r26,r30
    lsl  r26
    lsl  r26
    add  r30,r26
    lsl  r30
    ld   r26,y+
    andi r26,0xf
    add  r30,r26
    ret
_bin2bcd:
    ld   r26,y+
    clr  r30
bin2bcd0:
    subi r26,10
    brmi bin2bcd1
    subi r30,-16
    rjmp bin2bcd0
bin2bcd1:
    subi r26,-10
    add  r30,r26
    ret

	.CSEG

	.CSEG
_strlen:
    ld   r26,y+
    ld   r27,y+
    clr  r30
    clr  r31
strlen0:
    ld   r22,x+
    tst  r22
    breq strlen1
    adiw r30,1
    rjmp strlen0
strlen1:
    ret
_strlenf:
    clr  r26
    clr  r27
    ld   r30,y+
    ld   r31,y+
strlenf0:
	lpm  r0,z+
    tst  r0
    breq strlenf1
    adiw r26,1
    rjmp strlenf0
strlenf1:
    movw r30,r26
    ret

	.DSEG
___ds18b20_scratch_pad:
	.BYTE 0x9
_ds18b20_rom_codes:
	.BYTE 0x48
_temper:
	.BYTE 0x4
_lcd_buffer:
	.BYTE 0x50
_m:
	.BYTE 0x1
_sek:
	.BYTE 0x1
_s:
	.BYTE 0x1
_day:
	.BYTE 0x1
_d:
	.BYTE 0x1
_month:
	.BYTE 0x1
_mo:
	.BYTE 0x1
_year:
	.BYTE 0x1
_y:
	.BYTE 0x1
_menu:
	.BYTE 0x1
_n:
	.BYTE 0x1
_slaid:
	.BYTE 0x2
__base_y_G101:
	.BYTE 0x4
__lcd_x:
	.BYTE 0x1
__lcd_y:
	.BYTE 0x1
__lcd_maxx:
	.BYTE 0x1

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x0:
	STS  _temper,R30
	STS  _temper+1,R31
	STS  _temper+2,R22
	STS  _temper+3,R23
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x1:
	LDS  R26,_temper
	LDS  R27,_temper+1
	LDS  R24,_temper+2
	LDS  R25,_temper+3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x2:
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _lcd_gotoxy
	LDI  R30,LOW(_lcd_buffer)
	LDI  R31,HIGH(_lcd_buffer)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:19 WORDS
SUBOPT_0x3:
	ST   -Y,R31
	ST   -Y,R30
	LDS  R30,_d
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDS  R30,_mo
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDS  R30,_y
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x4:
	CALL _sprintf
	ADIW R28,16
	LDI  R30,LOW(_lcd_buffer)
	LDI  R31,HIGH(_lcd_buffer)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _lcd_puts

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:21 WORDS
SUBOPT_0x5:
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _lcd_gotoxy
	LDI  R30,LOW(_lcd_buffer)
	LDI  R31,HIGH(_lcd_buffer)
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x0,9
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:54 WORDS
SUBOPT_0x6:
	MOV  R30,R13
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDS  R30,_m
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDS  R30,_s
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x7:
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R8
	CALL __CWD1
	CALL __PUTPARD1
	LDI  R24,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x8:
	CALL _sprintf
	ADIW R28,8
	LDI  R30,LOW(_lcd_buffer)
	LDI  R31,HIGH(_lcd_buffer)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _lcd_puts

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:37 WORDS
SUBOPT_0x9:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL _sprintf
	ADIW R28,4
	LDI  R30,LOW(_lcd_buffer)
	LDI  R31,HIGH(_lcd_buffer)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _lcd_puts

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xA:
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _lcd_gotoxy
	LDI  R30,LOW(_lcd_buffer)
	LDI  R31,HIGH(_lcd_buffer)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 32 TIMES, CODE SIZE REDUCTION:59 WORDS
SUBOPT_0xB:
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0xC:
	LDI  R30,LOW(_lcd_buffer)
	LDI  R31,HIGH(_lcd_buffer)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0xD:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL _sprintf
	ADIW R28,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0xE:
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xF:
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	RJMP SUBOPT_0xB

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0x10:
	LDS  R26,_slaid
	LDS  R27,_slaid+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 17 TIMES, CODE SIZE REDUCTION:29 WORDS
SUBOPT_0x11:
	LDI  R30,LOW(20)
	LDI  R31,HIGH(20)
	RJMP SUBOPT_0xB

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x12:
	LDS  R30,_slaid
	LDS  R31,_slaid+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x13:
	STS  _slaid,R30
	STS  _slaid+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x14:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL _printf
	ADIW R28,2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x15:
	RCALL SUBOPT_0x10
	LDI  R30,LOW(2)
	CALL __MULB1W2U
	CP   R10,R30
	CPC  R11,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x16:
	RCALL SUBOPT_0x10
	LDI  R30,LOW(3)
	CALL __MULB1W2U
	CP   R10,R30
	CPC  R11,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x17:
	__POINTW1FN _0x0,202
	ST   -Y,R31
	ST   -Y,R30
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x18:
	RCALL SUBOPT_0x10
	LDI  R30,LOW(4)
	CALL __MULB1W2U
	CP   R10,R30
	CPC  R11,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x19:
	ST   -Y,R31
	ST   -Y,R30
	CALL _ds18b20_select
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1A:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _ds18b20_read_spd
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x1B:
	__GETD1N 0xC61C3C00
	LDD  R17,Y+0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x1C:
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	CALL __GETW1PF
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1D:
	ST   -Y,R30
	CALL __lcd_write_data
	LDI  R30,LOW(3)
	LDI  R31,HIGH(3)
	RJMP SUBOPT_0xB

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x1E:
	LDI  R30,LOW(48)
	ST   -Y,R30
	CALL __lcd_write_nibble_G101
	__DELAY_USW 400
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x1F:
	LDI  R30,LOW(142)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	JMP  _ds1302_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x20:
	ST   -Y,R30
	CALL _ds1302_write
	LDI  R30,LOW(142)
	ST   -Y,R30
	LDI  R30,LOW(128)
	ST   -Y,R30
	JMP  _ds1302_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x21:
	ST   -Y,R30
	CALL _ds1302_read
	ST   -Y,R30
	JMP  _bcd2bin

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x22:
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	CALL _bin2bcd
	ST   -Y,R30
	JMP  _ds1302_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x23:
	ST   -Y,R30
	LDD  R30,Y+2
	ST   -Y,R30
	CALL _bin2bcd
	ST   -Y,R30
	JMP  _ds1302_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x24:
	ST   -Y,R30
	LDD  R30,Y+1
	ST   -Y,R30
	CALL _bin2bcd
	RJMP SUBOPT_0x20

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x25:
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:21 WORDS
SUBOPT_0x26:
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x27:
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x28:
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x29:
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x2A:
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2B:
	MOVW R26,R28
	ADIW R26,12
	CALL __ADDW2R15
	CALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x2C:
	CALL __ADDW2R15
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	RET


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0xFA0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

	.equ __w1_port=0x1B
	.equ __w1_bit=0x00

_w1_init:
	clr  r30
	cbi  __w1_port,__w1_bit
	sbi  __w1_port-1,__w1_bit
	__DELAY_USW 0x780
	cbi  __w1_port-1,__w1_bit
	__DELAY_USB 0x4B
	sbis __w1_port-2,__w1_bit
	ret
	__DELAY_USW 0x130
	sbis __w1_port-2,__w1_bit
	ldi  r30,1
	__DELAY_USW 0x618
	ret

__w1_read_bit:
	sbi  __w1_port-1,__w1_bit
	__DELAY_USB 0xB
	cbi  __w1_port-1,__w1_bit
	__DELAY_USB 0x3B
	clc
	sbic __w1_port-2,__w1_bit
	sec
	ror  r30
	__DELAY_USW 0x140
	ret

__w1_write_bit:
	clt
	sbi  __w1_port-1,__w1_bit
	__DELAY_USB 0xB
	sbrc r23,0
	cbi  __w1_port-1,__w1_bit
	__DELAY_USB 0x45
	sbic __w1_port-2,__w1_bit
	rjmp __w1_write_bit0
	sbrs r23,0
	rjmp __w1_write_bit1
	ret
__w1_write_bit0:
	sbrs r23,0
	ret
__w1_write_bit1:
	__DELAY_USW 0x12C
	cbi  __w1_port-1,__w1_bit
	__DELAY_USB 0x1B
	set
	ret

_w1_read:
	ldi  r22,8
	__w1_read0:
	rcall __w1_read_bit
	dec  r22
	brne __w1_read0
	ret

_w1_write:
	ldi  r22,8
	ld   r23,y+
	clr  r30
__w1_write0:
	rcall __w1_write_bit
	brtc __w1_write1
	ror  r23
	dec  r22
	brne __w1_write0
	inc  r30
__w1_write1:
	ret

_w1_search:
	push r20
	push r21
	clr  r1
	clr  r20
	ld   r26,y
	ldd  r27,y+1
__w1_search0:
	mov  r0,r1
	clr  r1
	rcall _w1_init
	tst  r30
	breq __w1_search7
	ldd  r30,y+2
	st   -y,r30
	rcall _w1_write
	ldi  r21,1
__w1_search1:
	cp   r21,r0
	brsh __w1_search6
	rcall __w1_read_bit
	sbrc r30,7
	rjmp __w1_search2
	rcall __w1_read_bit
	sbrc r30,7
	rjmp __w1_search3
	rcall __sel_bit
	and  r24,r25
	brne __w1_search3
	mov  r1,r21
	rjmp __w1_search3
__w1_search2:
	rcall __w1_read_bit
__w1_search3:
	rcall __sel_bit
	and  r24,r25
	ldi  r23,0
	breq __w1_search5
__w1_search4:
	ldi  r23,1
__w1_search5:
	rcall __w1_write_bit
	rjmp __w1_search13
__w1_search6:
	rcall __w1_read_bit
	sbrs r30,7
	rjmp __w1_search9
	rcall __w1_read_bit
	sbrs r30,7
	rjmp __w1_search8
__w1_search7:
	mov  r30,r20
	pop  r21
	pop  r20
	adiw r28,3
	ret
__w1_search8:
	set
	rcall __set_bit
	rjmp __w1_search4
__w1_search9:
	rcall __w1_read_bit
	sbrs r30,7
	rjmp __w1_search10
	rjmp __w1_search11
__w1_search10:
	cp   r21,r0
	breq __w1_search12
	mov  r1,r21
__w1_search11:
	clt
	rcall __set_bit
	clr  r23
	rcall __w1_write_bit
	rjmp __w1_search13
__w1_search12:
	set
	rcall __set_bit
	ldi  r23,1
	rcall __w1_write_bit
__w1_search13:
	inc  r21
	cpi  r21,65
	brlt __w1_search1
	rcall __w1_read_bit
	rol  r30
	rol  r30
	andi r30,1
	adiw r26,8
	st   x,r30
	sbiw r26,8
	inc  r20
	tst  r1
	breq __w1_search7
	ldi  r21,9
__w1_search14:
	ld   r30,x
	adiw r26,9
	st   x,r30
	sbiw r26,8
	dec  r21
	brne __w1_search14
	rjmp __w1_search0

__sel_bit:
	mov  r30,r21
	dec  r30
	mov  r22,r30
	lsr  r30
	lsr  r30
	lsr  r30
	clr  r31
	add  r30,r26
	adc  r31,r27
	ld   r24,z
	ldi  r25,1
	andi r22,7
__sel_bit0:
	breq __sel_bit1
	lsl  r25
	dec  r22
	rjmp __sel_bit0
__sel_bit1:
	ret

__set_bit:
	rcall __sel_bit
	brts __set_bit2
	com  r25
	and  r24,r25
	rjmp __set_bit3
__set_bit2:
	or   r24,r25
__set_bit3:
	st   z,r24
	ret

_w1_dow_crc8:
	clr  r30
	ld   r24,y
	tst  r24
	breq __w1_dow_crc83
	ldi  r22,0x18
	ldd  r26,y+1
	ldd  r27,y+2
__w1_dow_crc80:
	ldi  r25,8
	ld   r31,x+
__w1_dow_crc81:
	mov  r23,r31
	eor  r23,r30
	ror  r23
	brcc __w1_dow_crc82
	eor  r30,r22
__w1_dow_crc82:
	ror  r30
	lsr  r31
	dec  r25
	brne __w1_dow_crc81
	dec  r24
	brne __w1_dow_crc80
__w1_dow_crc83:
	adiw r28,3
	ret

__ANEGF1:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __ANEGF10
	SUBI R23,0x80
__ANEGF10:
	RET

__ROUND_REPACK:
	TST  R21
	BRPL __REPACK
	CPI  R21,0x80
	BRNE __ROUND_REPACK0
	SBRS R30,0
	RJMP __REPACK
__ROUND_REPACK0:
	ADIW R30,1
	ADC  R22,R25
	ADC  R23,R25
	BRVS __REPACK1

__REPACK:
	LDI  R21,0x80
	EOR  R21,R23
	BRNE __REPACK0
	PUSH R21
	RJMP __ZERORES
__REPACK0:
	CPI  R21,0xFF
	BREQ __REPACK1
	LSL  R22
	LSL  R0
	ROR  R21
	ROR  R22
	MOV  R23,R21
	RET
__REPACK1:
	PUSH R21
	TST  R0
	BRMI __REPACK2
	RJMP __MAXRES
__REPACK2:
	RJMP __MINRES

__UNPACK:
	LDI  R21,0x80
	MOV  R1,R25
	AND  R1,R21
	LSL  R24
	ROL  R25
	EOR  R25,R21
	LSL  R21
	ROR  R24

__UNPACK1:
	LDI  R21,0x80
	MOV  R0,R23
	AND  R0,R21
	LSL  R22
	ROL  R23
	EOR  R23,R21
	LSL  R21
	ROR  R22
	RET

__CFD1U:
	SET
	RJMP __CFD1U0
__CFD1:
	CLT
__CFD1U0:
	PUSH R21
	RCALL __UNPACK1
	CPI  R23,0x80
	BRLO __CFD10
	CPI  R23,0xFF
	BRCC __CFD10
	RJMP __ZERORES
__CFD10:
	LDI  R21,22
	SUB  R21,R23
	BRPL __CFD11
	NEG  R21
	CPI  R21,8
	BRTC __CFD19
	CPI  R21,9
__CFD19:
	BRLO __CFD17
	SER  R30
	SER  R31
	SER  R22
	LDI  R23,0x7F
	BLD  R23,7
	RJMP __CFD15
__CFD17:
	CLR  R23
	TST  R21
	BREQ __CFD15
__CFD18:
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R23
	DEC  R21
	BRNE __CFD18
	RJMP __CFD15
__CFD11:
	CLR  R23
__CFD12:
	CPI  R21,8
	BRLO __CFD13
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R23
	SUBI R21,8
	RJMP __CFD12
__CFD13:
	TST  R21
	BREQ __CFD15
__CFD14:
	LSR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R21
	BRNE __CFD14
__CFD15:
	TST  R0
	BRPL __CFD16
	RCALL __ANEGD1
__CFD16:
	POP  R21
	RET

__CDF1U:
	SET
	RJMP __CDF1U0
__CDF1:
	CLT
__CDF1U0:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __CDF10
	CLR  R0
	BRTS __CDF11
	TST  R23
	BRPL __CDF11
	COM  R0
	RCALL __ANEGD1
__CDF11:
	MOV  R1,R23
	LDI  R23,30
	TST  R1
__CDF12:
	BRMI __CDF13
	DEC  R23
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R1
	RJMP __CDF12
__CDF13:
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R1
	PUSH R21
	RCALL __REPACK
	POP  R21
__CDF10:
	RET

__SWAPACC:
	PUSH R20
	MOVW R20,R30
	MOVW R30,R26
	MOVW R26,R20
	MOVW R20,R22
	MOVW R22,R24
	MOVW R24,R20
	MOV  R20,R0
	MOV  R0,R1
	MOV  R1,R20
	POP  R20
	RET

__UADD12:
	ADD  R30,R26
	ADC  R31,R27
	ADC  R22,R24
	RET

__NEGMAN1:
	COM  R30
	COM  R31
	COM  R22
	SUBI R30,-1
	SBCI R31,-1
	SBCI R22,-1
	RET

__SUBF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R25,0x80
	BREQ __ADDF129
	LDI  R21,0x80
	EOR  R1,R21

__ADDF120:
	CPI  R23,0x80
	BREQ __ADDF128
__ADDF121:
	MOV  R21,R23
	SUB  R21,R25
	BRVS __ADDF1211
	BRPL __ADDF122
	RCALL __SWAPACC
	RJMP __ADDF121
__ADDF122:
	CPI  R21,24
	BRLO __ADDF123
	CLR  R26
	CLR  R27
	CLR  R24
__ADDF123:
	CPI  R21,8
	BRLO __ADDF124
	MOV  R26,R27
	MOV  R27,R24
	CLR  R24
	SUBI R21,8
	RJMP __ADDF123
__ADDF124:
	TST  R21
	BREQ __ADDF126
__ADDF125:
	LSR  R24
	ROR  R27
	ROR  R26
	DEC  R21
	BRNE __ADDF125
__ADDF126:
	MOV  R21,R0
	EOR  R21,R1
	BRMI __ADDF127
	RCALL __UADD12
	BRCC __ADDF129
	ROR  R22
	ROR  R31
	ROR  R30
	INC  R23
	BRVC __ADDF129
	RJMP __MAXRES
__ADDF128:
	RCALL __SWAPACC
__ADDF129:
	RCALL __REPACK
	POP  R21
	RET
__ADDF1211:
	BRCC __ADDF128
	RJMP __ADDF129
__ADDF127:
	SUB  R30,R26
	SBC  R31,R27
	SBC  R22,R24
	BREQ __ZERORES
	BRCC __ADDF1210
	COM  R0
	RCALL __NEGMAN1
__ADDF1210:
	TST  R22
	BRMI __ADDF129
	LSL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVC __ADDF1210

__ZERORES:
	CLR  R30
	CLR  R31
	CLR  R22
	CLR  R23
	POP  R21
	RET

__MINRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	SER  R23
	POP  R21
	RET

__MAXRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	LDI  R23,0x7F
	POP  R21
	RET

__MULF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BREQ __ZERORES
	CPI  R25,0x80
	BREQ __ZERORES
	EOR  R0,R1
	SEC
	ADC  R23,R25
	BRVC __MULF124
	BRLT __ZERORES
__MULF125:
	TST  R0
	BRMI __MINRES
	RJMP __MAXRES
__MULF124:
	PUSH R0
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R17
	CLR  R18
	CLR  R25
	MUL  R22,R24
	MOVW R20,R0
	MUL  R24,R31
	MOV  R19,R0
	ADD  R20,R1
	ADC  R21,R25
	MUL  R22,R27
	ADD  R19,R0
	ADC  R20,R1
	ADC  R21,R25
	MUL  R24,R30
	RCALL __MULF126
	MUL  R27,R31
	RCALL __MULF126
	MUL  R22,R26
	RCALL __MULF126
	MUL  R27,R30
	RCALL __MULF127
	MUL  R26,R31
	RCALL __MULF127
	MUL  R26,R30
	ADD  R17,R1
	ADC  R18,R25
	ADC  R19,R25
	ADC  R20,R25
	ADC  R21,R25
	MOV  R30,R19
	MOV  R31,R20
	MOV  R22,R21
	MOV  R21,R18
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	POP  R0
	TST  R22
	BRMI __MULF122
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	RJMP __MULF123
__MULF122:
	INC  R23
	BRVS __MULF125
__MULF123:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__MULF127:
	ADD  R17,R0
	ADC  R18,R1
	ADC  R19,R25
	RJMP __MULF128
__MULF126:
	ADD  R18,R0
	ADC  R19,R1
__MULF128:
	ADC  R20,R25
	ADC  R21,R25
	RET

__CMPF12:
	TST  R25
	BRMI __CMPF120
	TST  R23
	BRMI __CMPF121
	CP   R25,R23
	BRLO __CMPF122
	BRNE __CMPF121
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	BRLO __CMPF122
	BREQ __CMPF123
__CMPF121:
	CLZ
	CLC
	RET
__CMPF122:
	CLZ
	SEC
	RET
__CMPF123:
	SEZ
	CLC
	RET
__CMPF120:
	TST  R23
	BRPL __CMPF122
	CP   R25,R23
	BRLO __CMPF121
	BRNE __CMPF122
	CP   R30,R26
	CPC  R31,R27
	CPC  R22,R24
	BRLO __CMPF122
	BREQ __CMPF123
	RJMP __CMPF121

__ADDW2R15:
	CLR  R0
	ADD  R26,R15
	ADC  R27,R0
	RET

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__ANEGD1:
	COM  R31
	COM  R22
	COM  R23
	NEG  R30
	SBCI R31,-1
	SBCI R22,-1
	SBCI R23,-1
	RET

__ASRW12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	BREQ __ASRW12R
__ASRW12L:
	ASR  R31
	ROR  R30
	DEC  R0
	BRNE __ASRW12L
__ASRW12R:
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__LNEGB1:
	TST  R30
	LDI  R30,1
	BREQ __LNEGB1F
	CLR  R30
__LNEGB1F:
	RET

__MULB1W2U:
	MOV  R22,R30
	MUL  R22,R26
	MOVW R30,R0
	MUL  R22,R27
	ADD  R31,R0
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__PUTPARD1:
	ST   -Y,R23
	ST   -Y,R22
	ST   -Y,R31
	ST   -Y,R30
	RET

__SAVELOCR6:
	ST   -Y,R21
__SAVELOCR5:
	ST   -Y,R20
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR6:
	LDD  R21,Y+5
__LOADLOCR5:
	LDD  R20,Y+4
__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
